/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.enhancedcelestials.world.level.levelgen.structure.crater;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgitaco.enhancedcelestials.world.level.levelgen.structure.ECStructureTypes;
import corgitaco.enhancedcelestials.world.level.levelgen.structure.crater.CraterPiece;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;

public class CraterStructure
extends Structure {
    public static final Codec<CraterStructure> CODEC = RecordCodecBuilder.mapCodec(archStructureInstance -> archStructureInstance.group((App)CraterStructure.m_226567_((RecordCodecBuilder.Instance)archStructureInstance)).apply((Applicative)archStructureInstance, CraterStructure::new)).codec();

    public CraterStructure(Structure.StructureSettings structureSettings) {
        super(structureSettings);
    }

    private static void generatePieces(StructurePiecesBuilder piecesBuilder, Structure.GenerationContext context) {
        double baseRadiusX;
        WorldgenRandom random = context.f_226626_();
        int seed = random.m_188502_();
        ChunkPos chunkPos = context.f_226628_();
        int blockX = chunkPos.m_151382_(random.m_188503_(16));
        int blockZ = chunkPos.m_151391_(random.m_188503_(16));
        ChunkGenerator chunkGenerator = context.f_226622_();
        RandomState randomState = context.f_226624_();
        int baseHeight = chunkGenerator.m_214096_(blockX, blockZ, Heightmap.Types.OCEAN_FLOOR_WG, context.f_226629_(), randomState);
        BlockPos origin = new BlockPos(blockX, baseHeight, blockZ);
        double baseRadiusZ = baseRadiusX = 128.0;
        double threshold = 1.0;
        int coneSizePackedX = SectionPos.m_235865_((double)baseRadiusX) + 1;
        int coneSizePackedZ = SectionPos.m_235865_((double)baseRadiusZ) + 1;
        ArrayList<CraterPiece> craterPieceList = new ArrayList<CraterPiece>();
        for (int x = -coneSizePackedX; x <= coneSizePackedX; ++x) {
            for (int z = -coneSizePackedZ; z <= coneSizePackedZ; ++z) {
                int chunkX = SectionPos.m_123171_((int)blockX) + x;
                int chunkZ = SectionPos.m_123171_((int)blockZ) + z;
                long chunk = ChunkPos.m_45589_((int)chunkX, (int)chunkZ);
                if (!CraterStructure.isCraterSafe(chunkX, chunkZ, chunkGenerator, biomeHolder -> !biomeHolder.m_203656_(BiomeTags.f_207603_) && !biomeHolder.m_203656_(BiomeTags.f_207605_), randomState)) {
                    return;
                }
                craterPieceList.add(new CraterPiece(new PieceStructureInfo(origin, seed, baseRadiusX, baseRadiusZ, threshold), 0, CraterStructure.getWritableArea(new ChunkPos(chunk), context.f_226629_())));
            }
        }
        craterPieceList.forEach(arg_0 -> ((StructurePiecesBuilder)piecesBuilder).m_142679_(arg_0));
    }

    public static BoundingBox getWritableArea(ChunkPos chunkPos, LevelHeightAccessor accessor) {
        int i = chunkPos.m_45604_();
        int j = chunkPos.m_45605_();
        int k = accessor.m_141937_() + 1;
        int l = accessor.m_151558_() - 1;
        return new BoundingBox(i, k, j, i + 15, l, j + 15);
    }

    public static boolean isCraterSafe(int sectionX, int sectionZ, ChunkGenerator generator, Predicate<Holder<Biome>> isBiome, RandomState randomState) {
        for (int xOffset = 0; xOffset < 4; ++xOffset) {
            for (int zOffset = 0; zOffset < 4; ++zOffset) {
                int quartX = QuartPos.m_175400_((int)SectionPos.m_123223_((int)sectionX)) + xOffset;
                int quartY = QuartPos.m_175400_((int)generator.m_6337_());
                int quartZ = QuartPos.m_175400_((int)SectionPos.m_123223_((int)sectionZ)) + zOffset;
                if (isBiome.test((Holder<Biome>)generator.m_62218_().m_203407_(quartX, quartY, quartZ, randomState.m_224579_()))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean matchesBiome(BlockPos pos, ChunkGenerator generator, Predicate<Holder<Biome>> isBiome, RandomState randomState) {
        return isBiome.test((Holder<Biome>)generator.m_62218_().m_203407_(QuartPos.m_175400_((int)pos.m_123341_()), QuartPos.m_175400_((int)pos.m_123342_()), QuartPos.m_175400_((int)pos.m_123343_()), randomState.m_224579_()));
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext generationContext) {
        return CraterStructure.m_226585_((Structure.GenerationContext)generationContext, (Heightmap.Types)Heightmap.Types.WORLD_SURFACE_WG, piecesBuilder -> CraterStructure.generatePieces(piecesBuilder, generationContext));
    }

    public StructureType<?> m_213658_() {
        return ECStructureTypes.CRATER.get();
    }

    static {
        String string = "";
    }

    public record PieceStructureInfo(BlockPos origin, int noiseSeed, double baseRadiusX, double baseRadiusZ, double threshold) {
        public static final Codec<PieceStructureInfo> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)BlockPos.f_121852_.fieldOf("origin").forGetter(PieceStructureInfo::origin), (App)Codec.INT.fieldOf("noiseSeed").forGetter(PieceStructureInfo::noiseSeed), (App)Codec.DOUBLE.fieldOf("baseRadiusX").forGetter(PieceStructureInfo::baseRadiusX), (App)Codec.DOUBLE.fieldOf("baseRadiusZ").forGetter(PieceStructureInfo::baseRadiusZ), (App)Codec.DOUBLE.fieldOf("threshold").forGetter(PieceStructureInfo::threshold)).apply((Applicative)builder, PieceStructureInfo::new));
    }
}

